/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import icyllis.modernui.view.InputEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class MotionEvent
extends InputEvent {
    public static final int INVALID_POINTER_ID = -1;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_OUTSIDE = 4;
    public static final int ACTION_POINTER_DOWN = 5;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_HOVER_MOVE = 7;
    public static final int ACTION_SCROLL = 8;
    public static final int ACTION_HOVER_ENTER = 9;
    public static final int ACTION_HOVER_EXIT = 10;
    public static final int ACTION_BUTTON_PRESS = 11;
    public static final int ACTION_BUTTON_RELEASE = 12;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;
    public static final int FLAG_HOVER_EXIT_PENDING = 4;
    public static final int BUTTON_PRIMARY = 1;
    public static final int BUTTON_SECONDARY = 2;
    public static final int BUTTON_TERTIARY = 4;
    public static final int BUTTON_BACK = 8;
    public static final int BUTTON_FORWARD = 16;
    public static final int TOOL_TYPE_UNKNOWN = 0;
    public static final int TOOL_TYPE_FINGER = 1;
    public static final int TOOL_TYPE_STYLUS = 2;
    public static final int TOOL_TYPE_MOUSE = 3;
    public static final int TOOL_TYPE_ERASER = 4;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_VSCROLL = 9;
    public static final int AXIS_HSCROLL = 10;
    @Deprecated
    private static final int HISTORY_CURRENT = Integer.MIN_VALUE;
    private static final float INVALID_CURSOR_POSITION = Float.NaN;
    private static final int MAX_RECYCLED = 10;
    private static final Object sRecyclerLock = new Object();
    private static MotionEvent sRecyclerTop;
    private static int sRecyclerUsed;
    private static final Object gSharedTempLock;
    private static PointerCoords[] gSharedTempPointerCoords;
    private static PointerProperties[] gSharedTempPointerProperties;
    private MotionEvent mNext;
    private int mAction;
    private int mActionButton;
    private int mFlags;
    private int mModifiers;
    private int mButtonState;
    private float mXOffset;
    private float mYOffset;
    private float mRawXCursorPosition;
    private float mRawYCursorPosition;
    private long mDownTime;
    private long mEventTime;
    private final ObjectArrayList<PointerProperties> mPointerProperties = new ObjectArrayList();
    private final ObjectArrayList<PointerCoords> mPointerCoords = new ObjectArrayList();

    private static void ensureSharedTempPointerCapacity(int desiredCapacity) {
        if (gSharedTempPointerCoords == null || gSharedTempPointerCoords.length < desiredCapacity) {
            int capacity;
            int n = capacity = gSharedTempPointerCoords != null ? gSharedTempPointerCoords.length : 1;
            while (capacity < desiredCapacity) {
                capacity *= 2;
            }
            gSharedTempPointerCoords = PointerCoords.createArray(capacity);
            gSharedTempPointerProperties = PointerProperties.createArray(capacity);
        }
    }

    private MotionEvent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static MotionEvent obtain() {
        MotionEvent event;
        Object object = sRecyclerLock;
        synchronized (object) {
            event = sRecyclerTop;
            if (event == null) {
                return new MotionEvent();
            }
            sRecyclerTop = event.mNext;
            --sRecyclerUsed;
        }
        event.mNext = null;
        event.prepareForReuse();
        return event;
    }

    @Nonnull
    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointerCount, PointerProperties[] properties, PointerCoords[] coords, int modifiers, int buttonState, int flags) {
        MotionEvent event = MotionEvent.obtain();
        event.initialize(action, 0, flags, modifiers, buttonState, 0.0f, 0.0f, Float.NaN, Float.NaN, downTime, eventTime, pointerCount, properties, coords);
        return event;
    }

    @Nonnull
    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, int modifiers) {
        return MotionEvent.obtain(downTime, eventTime, action, 0, x, y, modifiers, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static MotionEvent obtain(long downTime, long eventTime, int action, int actionButton, float x, float y, int modifiers, int buttonState, int flags) {
        int actionMasked = action & 0xFF;
        if ((actionMasked == 11 || actionMasked == 12) && actionButton == 0) {
            throw new IllegalArgumentException("actionButton should be defined for action press or release");
        }
        MotionEvent event = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerProperties[] properties = gSharedTempPointerProperties;
            properties[0].reset();
            properties[0].id = 0;
            PointerCoords[] coords = gSharedTempPointerCoords;
            coords[0].reset();
            coords[0].setAxisValue(0, x);
            coords[0].setAxisValue(1, y);
            event.initialize(action, actionButton, flags, modifiers, buttonState, 0.0f, 0.0f, Float.NaN, Float.NaN, downTime, eventTime, 1, properties, coords);
            return event;
        }
    }

    @Nonnull
    public static MotionEvent obtain(@Nonnull MotionEvent other) {
        MotionEvent ev = MotionEvent.obtain();
        ev.copyFrom(other);
        return ev;
    }

    private void copyFrom(@Nonnull MotionEvent other) {
        this.mAction = other.mAction;
        this.mActionButton = other.mActionButton;
        this.mFlags = other.mFlags;
        this.mModifiers = other.mModifiers;
        this.mButtonState = other.mButtonState;
        this.mXOffset = other.mXOffset;
        this.mYOffset = other.mYOffset;
        this.mRawXCursorPosition = other.mRawXCursorPosition;
        this.mRawYCursorPosition = other.mRawYCursorPosition;
        this.mDownTime = other.mDownTime;
        this.mEventTime = other.mEventTime;
        this.mPointerProperties.clear();
        this.mPointerProperties.addAll(other.mPointerProperties);
        this.mPointerCoords.clear();
        this.mPointerCoords.addAll(other.mPointerCoords);
    }

    private void initialize(int action, int actionButton, int flags, int modifiers, int buttonState, float xOffset, float yOffset, float rawXCursorPosition, float rawYCursorPosition, long downTime, long eventTime, int pointerCount, @Nonnull PointerProperties[] pointerProperties, @Nonnull PointerCoords[] pointerCoords) {
        if (pointerCount < 1) {
            throw new IllegalArgumentException("pointerCount must be at least 1");
        }
        if (pointerProperties.length < pointerCount) {
            throw new IllegalArgumentException("pointerProperties array must be large enough to hold all pointers");
        }
        if (pointerCoords.length < pointerCount) {
            throw new IllegalArgumentException("pointerCoords array must be large enough to hold all pointers");
        }
        this.mAction = action;
        this.mActionButton = actionButton;
        this.mFlags = flags;
        this.mModifiers = modifiers;
        this.mButtonState = buttonState;
        this.mXOffset = xOffset;
        this.mYOffset = yOffset;
        this.mRawXCursorPosition = rawXCursorPosition;
        this.mRawYCursorPosition = rawYCursorPosition;
        this.mDownTime = downTime;
        this.mEventTime = eventTime;
        this.mPointerProperties.clear();
        this.mPointerProperties.addElements(0, (Object[])pointerProperties, 0, pointerCount);
        this.mPointerCoords.clear();
        this.mPointerCoords.addElements(0, (Object[])pointerCoords, 0, pointerCount);
        this.updateCursorPosition();
    }

    private void updateCursorPosition() {
        float x = 0.0f;
        float y = 0.0f;
        int pointerCount = this.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            x += this.getX(i);
            y += this.getY(i);
        }
        this.setCursorPosition(x /= (float)pointerCount, y /= (float)pointerCount);
    }

    private void setCursorPosition(float x, float y) {
        this.mRawXCursorPosition = x - this.mXOffset;
        this.mRawYCursorPosition = y - this.mYOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recycle() {
        super.recycle();
        Object object = sRecyclerLock;
        synchronized (object) {
            if (sRecyclerUsed < 10) {
                ++sRecyclerUsed;
                this.mNext = sRecyclerTop;
                sRecyclerTop = this;
            }
        }
    }

    public final int getAction() {
        return this.mAction;
    }

    public final int getActionMasked() {
        return this.mAction & 0xFF;
    }

    public final int getActionIndex() {
        return (this.mAction & 0xFF00) >> 8;
    }

    public final boolean isTouchEvent() {
        switch (this.mAction & 0xFF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public final void setAction(int action) {
        this.mAction = action;
    }

    public final int getButtonState() {
        return this.mButtonState;
    }

    public final boolean isButtonPressed(int button) {
        if (button == 0) {
            return false;
        }
        return (this.mButtonState & button) == button;
    }

    public final int getPointerCount() {
        return this.mPointerProperties.size();
    }

    public final int getPointerId(int pointerIndex) {
        if (pointerIndex < 0 || pointerIndex >= this.getPointerCount()) {
            throw new IllegalArgumentException("pointerIndex out of range");
        }
        return ((PointerProperties)this.mPointerProperties.get((int)pointerIndex)).id;
    }

    public final int getToolType(int pointerIndex) {
        if (pointerIndex < 0 || pointerIndex >= this.getPointerCount()) {
            throw new IllegalArgumentException("pointerIndex out of range");
        }
        return ((PointerProperties)this.mPointerProperties.get((int)pointerIndex)).toolType;
    }

    public final boolean isHoverExitPending() {
        return (this.mFlags & 4) != 0;
    }

    public void setHoverExitPending(boolean hoverExitPending) {
        this.mFlags = hoverExitPending ? this.mFlags | 4 : this.mFlags & 0xFFFFFFFB;
    }

    @Override
    @Nonnull
    public MotionEvent copy() {
        return MotionEvent.obtain(this);
    }

    public final long getDownTime() {
        return this.mDownTime / 1000000L;
    }

    @Override
    public long getEventTime() {
        return this.mEventTime / 1000000L;
    }

    @Override
    public long getEventTimeNano() {
        return this.mEventTime;
    }

    @Override
    public void cancel() {
        this.setAction(3);
    }

    private PointerCoords getRawPointerCoords(int pointerIndex) {
        return (PointerCoords)this.mPointerCoords.get(pointerIndex);
    }

    private float getRawAxisValue(int axis, int pointerIndex) {
        if (pointerIndex < 0 || pointerIndex >= this.getPointerCount()) {
            throw new IllegalArgumentException("pointerIndex out of range");
        }
        return this.getRawPointerCoords(pointerIndex).getAxisValue(axis);
    }

    private float getAxisValue(int axis, int pointerIndex) {
        if (pointerIndex < 0 || pointerIndex >= this.getPointerCount()) {
            throw new IllegalArgumentException("pointerIndex out of range");
        }
        float value = this.getRawPointerCoords(pointerIndex).getAxisValue(axis);
        switch (axis) {
            case 0: {
                return value + this.mXOffset;
            }
            case 1: {
                return value + this.mYOffset;
            }
        }
        return value;
    }

    void setRawAxisValue(int axis, float value) {
        this.getRawPointerCoords(0).setAxisValue(axis, value);
    }

    void setRawAxisValue(int axis, float value, int pointerIndex) {
        if (pointerIndex < 0 || pointerIndex >= this.getPointerCount()) {
            throw new IllegalArgumentException("pointerIndex out of range");
        }
        this.getRawPointerCoords(pointerIndex).setAxisValue(axis, value);
    }

    public final float getAxisValue(int axis) {
        return this.getAxisValue(axis, 0);
    }

    public final float getX() {
        return this.getAxisValue(0, 0);
    }

    public final float getY() {
        return this.getAxisValue(1, 0);
    }

    public final float getX(int pointerIndex) {
        return this.getAxisValue(0, pointerIndex);
    }

    public final float getY(int pointerIndex) {
        return this.getAxisValue(1, pointerIndex);
    }

    public final float getRawX() {
        return this.getRawAxisValue(0, 0);
    }

    public final float getRawY() {
        return this.getRawAxisValue(1, 0);
    }

    public float getRawX(int pointerIndex) {
        return this.getRawAxisValue(0, pointerIndex);
    }

    public float getRawY(int pointerIndex) {
        return this.getRawAxisValue(1, pointerIndex);
    }

    public int getActionButton() {
        return this.mActionButton;
    }

    public float getXCursorPosition() {
        return this.mRawXCursorPosition + this.mXOffset;
    }

    public float getYCursorPosition() {
        return this.mRawYCursorPosition + this.mYOffset;
    }

    public final void offsetLocation(float deltaX, float deltaY) {
        this.mXOffset += deltaX;
        this.mYOffset += deltaY;
    }

    public final void setLocation(float x, float y) {
        float oldX = this.getX();
        float oldY = this.getY();
        this.offsetLocation(x - oldX, y - oldY);
    }

    public final boolean hasModifiers(int modifiers) {
        if (modifiers == 0) {
            return this.mModifiers == 0;
        }
        return (this.mModifiers & modifiers) == modifiers;
    }

    public final boolean isShiftPressed() {
        return (this.mModifiers & 1) != 0;
    }

    public final boolean isCtrlPressed() {
        if (Minecraft.field_142025_a) {
            return (this.mModifiers & 8) != 0;
        }
        return (this.mModifiers & 2) != 0;
    }

    public final boolean isAltPressed() {
        return (this.mModifiers & 4) != 0;
    }

    public final boolean isSuperPressed() {
        return (this.mModifiers & 8) != 0;
    }

    public final boolean isCapsLockOn() {
        return (this.mModifiers & 0x10) != 0;
    }

    public final boolean isNumLockOn() {
        return (this.mModifiers & 0x20) != 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("action", (Object)MotionEvent.actionToString(this.mAction)).append("x", this.getX()).append("y", this.getY()).append("flags", (Object)("0x" + Integer.toHexString(this.mFlags))).append("eventTime", this.getEventTime()).toString();
    }

    public static String actionToString(int action) {
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
            case 9: {
                return "ACTION_HOVER_ENTER";
            }
            case 10: {
                return "ACTION_HOVER_EXIT";
            }
            case 11: {
                return "ACTION_BUTTON_PRESS";
            }
            case 12: {
                return "ACTION_BUTTON_RELEASE";
            }
        }
        int index = (action & 0xFF00) >> 8;
        switch (action & 0xFF) {
            case 5: {
                return "ACTION_POINTER_DOWN(" + index + ")";
            }
            case 6: {
                return "ACTION_POINTER_UP(" + index + ")";
            }
        }
        return Integer.toString(action);
    }

    static {
        gSharedTempLock = new Object();
    }

    public static final class PointerProperties {
        public int id;
        public int toolType;

        public PointerProperties() {
            this.reset();
        }

        public PointerProperties(PointerProperties other) {
            this.copyFrom(other);
        }

        @Nonnull
        public static PointerProperties[] createArray(int size) {
            PointerProperties[] array = new PointerProperties[size];
            for (int i = 0; i < size; ++i) {
                array[i] = new PointerProperties();
            }
            return array;
        }

        public void reset() {
            this.id = -1;
            this.toolType = 0;
        }

        public void copyFrom(@Nonnull PointerProperties other) {
            this.id = other.id;
            this.toolType = other.toolType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PointerProperties that = (PointerProperties)o;
            return this.id == that.id && this.toolType == that.toolType;
        }

        public int hashCode() {
            return this.id | this.toolType << 8;
        }
    }

    public static final class PointerCoords {
        private static final int INITIAL_PACKED_AXIS_VALUES = 8;
        private long mPackedAxisBits;
        private float[] mPackedAxisValues;

        public PointerCoords() {
        }

        public PointerCoords(PointerCoords other) {
            this.copyFrom(other);
        }

        @Nonnull
        public static PointerCoords[] createArray(int size) {
            PointerCoords[] array = new PointerCoords[size];
            for (int i = 0; i < size; ++i) {
                array[i] = new PointerCoords();
            }
            return array;
        }

        public void reset() {
            this.mPackedAxisBits = 0L;
        }

        public void copyFrom(@Nonnull PointerCoords other) {
            long bits;
            this.mPackedAxisBits = bits = other.mPackedAxisBits;
            if (bits != 0L) {
                float[] otherValues = other.mPackedAxisValues;
                int count = Long.bitCount(bits);
                float[] values = this.mPackedAxisValues;
                if (values == null || count > values.length) {
                    this.mPackedAxisValues = values = new float[otherValues.length];
                }
                System.arraycopy(otherValues, 0, values, 0, count);
            }
        }

        public float getAxisValue(int axis) {
            if (axis < 0 || axis > 63) {
                throw new IllegalArgumentException("Axis out of range.");
            }
            long bits = this.mPackedAxisBits;
            long axisBit = Long.MIN_VALUE >>> axis;
            if ((bits & axisBit) == 0L) {
                return 0.0f;
            }
            int index = Long.bitCount(bits & (-1L >>> axis ^ 0xFFFFFFFFFFFFFFFFL));
            return this.mPackedAxisValues[index];
        }

        public void setAxisValue(int axis, float value) {
            if (axis < 0 || axis > 63) {
                throw new IllegalArgumentException("Axis out of range.");
            }
            long bits = this.mPackedAxisBits;
            long axisBit = Long.MIN_VALUE >>> axis;
            int index = Long.bitCount(bits & (-1L >>> axis ^ 0xFFFFFFFFFFFFFFFFL));
            float[] values = this.mPackedAxisValues;
            if ((bits & axisBit) == 0L) {
                if (values == null) {
                    this.mPackedAxisValues = values = new float[8];
                } else {
                    int count = Long.bitCount(bits);
                    if (count < values.length) {
                        if (index != count) {
                            System.arraycopy(values, index, values, index + 1, count - index);
                        }
                    } else {
                        float[] newValues = new float[count * 2];
                        System.arraycopy(values, 0, newValues, 0, index);
                        System.arraycopy(values, index, newValues, index + 1, count - index);
                        this.mPackedAxisValues = values = newValues;
                    }
                }
                this.mPackedAxisBits = bits | axisBit;
            }
            values[index] = value;
        }
    }
}

